<?php
header("Content-Type: application/json");

require __DIR__ . '/vendor/autoload.php'; // Composer autoloader
require_once 'UserCollection.php';  // Our custom Firestore class
require __DIR__ . '/Razorpay0/Razorpay.php';

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

// Razorpay API Keys
$keyId = "rzp_live_RFNrVJa7XIQtOK";
$keySecret = "W8NGFxZYfm0aStJYFKBsytFj";

// Firebase service account path
$serviceAccountPath = __DIR__ . '/firebase-service-account.json';

// Parse JSON input
$input = json_decode(file_get_contents("php://input"), true);

// Validate required input
if (!isset($input['razorpay_order_id'], $input['razorpay_payment_id'], $input['razorpay_signature'], $input['uid'])) {
    http_response_code(400);
    echo json_encode([
        "status" => "failure",
        "message" => "Missing required parameters"
    ]);
    exit;
}

$orderId   = $input['razorpay_order_id'];
$paymentId = $input['razorpay_payment_id'];
$signature = $input['razorpay_signature'];
$documentId = $input['uid'];

// Verify Razorpay Signature
$generatedSignature = hash_hmac('sha256', $orderId . "|" . $paymentId, $keySecret);

if (hash_equals($generatedSignature, $signature)) { 
     echo json_encode([
                "status" => "success",
                "message" => "Payment Successfull",
                "order_id" => $orderId,
                "payment_id" => $paymentId
            ]);
} else { 
    http_response_code(400);
    echo json_encode([
        "status" => "failure",
        "message" => "Invalid signature"
    ]);
}


// // Parse request
// $input = json_decode(file_get_contents("php://input"), true);

// $orderId   = $input['razorpay_order_id'];
// $paymentId = $input['razorpay_payment_id'];
// $document_id = $input['user_id'];


// $generatedSignature = hash_hmac('sha256', $orderId . "|" . $paymentId, $keySecret);

// if ($generatedSignature === $signature) {
//     // Create instance of updater
//     $updater = new UserCollection($serviceAccountPath);
    
    
//     // Data to update
//     $updateData = [
//         'coins' => 1231, 
//     ];
    
//     // Call the update
//     $result = $updater->updateUser($document_id, $updateData);
//     echo json_encode([
//         "status" => "success",
//         "order_id" => $orderId, 
//         "payment_id" => $paymentId
//     ]);
// } else {
//     http_response_code(400);
//     echo json_encode([
//         "status" => "failure",
//         "message" => "Invalid signature"
//     ]);
// }
